model Ex9_12
extends Modelica.Math;

// Variables

Real n(unit="")                             "Polytropic index";
Real V1(unit="m^3")                         "Total volume at state 1";
Real V0(unit="m^3")                         "Displaced volume";
Real V2(unit="m^3")                         "Total volume after expansion";
Real W(unit="kJ")                           "Work done by steam in the expansion process";
Real v2(unit="m^3/kg")                      "Specific volume at state 2";
Real x2(unit="")                            "Dryness fraction";
Real u2(unit="kJ/kg")                       "Internal energy at state 2";
Real u1(unit="kJ/kg")                       "Internal energy at state 1";
Real Q(unit="kJ")                           "Heat transfer";


// Parameters
 parameter Real m(unit="kg")=0.02                  "Mass of piston";
 parameter Real p1(unit="MPa")=0.6                 "Initial pressure of steam";
 parameter Real p2(unit="Mpa")=0.12                "Final pressure of steam";
 parameter Real d(unit="m")=0.28                   "Diameter of cylinder";
 parameter Real l(unit="m")=0.305                  "length of cylinder";
 
 // According to steam table,200 degree celsius and 0.6 MPa
 parameter Real v1(unit="m^3/kg")=0.352                   "Specific volume";
 parameter Real h1(unit="kJ/kg")=2850.1                   "Enthalpy";
 // According to steam table,200 degree celsius and 0.12 MPa
 parameter Real vf(unit="m^3/kg")=0.0010476              "Specific volume of liquid";
 parameter Real vfg(unit="m^3/kg")=1.4271                "Specific volume";
 parameter Real uf(unit="kJ/kg")=439.3                   "Internal energy of fluid";
 parameter Real ug(unit="kJ/kg")=2512                    "Internal energy of gas";
 
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

 // Equations
equation 

n=log(p1/p2)/log(V2/V1);
V1=v1*m;
V0=pi*d^2*l/4;
V2=V1+V0;
W=(p1*V1-p2*V2)*1e06/((n-1)*1e03);
v2=V2/m;
x2=(v2-vf)/vfg;
u2=uf+x2*(ug-uf);
u1=h1-(p1*1e06*V1*1e-03/m);
Q=m*(u2-u1)+W;


end Ex9_12;
