package Ex9_16
model Ex9_16_a


// Variables
Real fhi1(unit="kJ/kg")                       "Exergy of the system 1";
Real fhi2(unit="kJ/kg")                       "Exergy of the system 2";
Real fhi(unit="kJ")                           "Total exergy of the system";


// Parameters
  parameter Real m(unit="kg")=3             "Rate of mass of steam received by turbine";
  parameter Real T0(unit="kg")=300          "Surrounding temperature";
  
 // From the mollier diagram,at the dead state of 1 bar and 300 K
 
 parameter Real u0(unit="kJ/kg")=113.1                 "Internal energy";
 parameter Real s0(unit="kJ/kg*K")=0.395               "Entropy";
 parameter Real h0(unit="kJ/kg")=113.2                 "Enthalpy of gas";
 parameter Real v0(unit="m^3/kg")=0.001005             "specific volume";
 
 // From the mollier diagram,For water at 1 bar and 90 degree celsius
 parameter Real u(unit="kJ/kg")=376.9               "Internal energy";
 parameter Real s(unit="kJ/kg*K")=1.193             "Entropy";
 parameter Real h(unit="kJ/kg")=377                 "Enthalpy";
 parameter Real v(unit="m^3/kg")=0.001035           "Specific volume";
 
 // Equations

equation

fhi1=h0-T0*s0;
fhi2=h-T0*s;
fhi=m*(fhi2-fhi1);

end Ex9_16_a;
//================================================================================================

model Ex9_16_b


// Variables
Real fhi1(unit="kJ/kg")                    "Exergy of the system 1";
Real fhi2(unit="kJ/kg")                    "Exergy of the system 2";
Real fhi(unit="kJ")                        "Total exergy of the system";


// Parameters
  parameter Real m(unit="kg")=0.2           "Rate of mass of steam received by turbine";
  parameter Real T0(unit="K")=300           "Surrounding temperature";
  parameter Real p0(unit="kPa")=100         "Surrounding Pressure";
  
 // From the mollier diagram,at the dead state of 1 bar and 300 K
 
 parameter Real u0(unit="kJ/kg")=113.1                 "Internal energy";
 parameter Real s0(unit="kJ/kg*K")=0.395               "Entropy";
 parameter Real h0(unit="kJ/kg")=113.2                 "Enthalpy of gas";
 parameter Real v0(unit="m^3/kg")=0.001005             "specific volume";
 
 // From the mollier diagram, at 4 MPa and 500 degree celsius
 parameter Real u(unit="kJ/kg")=3099.8                 "Internal energy";
 parameter Real s(unit="kJ/kg*K")=7.090                "Entropy";
 parameter Real h(unit="kJ/kg")=3446.3                 "Enthalpy";
 parameter Real v(unit="m^3/kg")=0.08637               "Specific volume";
 
 // Equations

equation

fhi1=h0-T0*s0;
fhi2=u+p0*v-T0*s;
fhi=m*(fhi2-fhi1);

end Ex9_16_b;

//===============================================================================================


model Ex9_16_c

// Variables
Real u(unit="kJ/kg")                         "Internal energy";
Real h(unit="kJ/kg")                         "Enthalpy";
Real s(unit="kJ/kg*K")                       "Entropy";
Real v(unit="m^3/kg")                        "Specific volume";
Real fhi1(unit="kJ/kg")                      "Exergy of the system 1";
Real fhi2(unit="kJ/kg")                      "Exergy of the system 2";
Real fhi(unit="kJ")                          "Total exergy of the system";


// Parameters

  parameter Real m(unit="kg")=0.4             "Rate of mass of steam received by turbine";
  parameter Real T0(unit="K")=300             "Surrounding temperature";
  parameter Real p0(unit="kPa")=100           "Surrounding Pressure";
  
  
 // From the mollier diagram,at the dead state of 1 bar and 300 K
 
 parameter Real u0(unit="kJ/kg")=113.1                 "Internal energy";
 parameter Real s0(unit="kJ/kg*K")=0.395               "Entropy";
 parameter Real h0(unit="kJ/kg")=113.2                 "Enthalpy of gas";
 parameter Real v0(unit="m^3/kg")=0.001005             "specific volume";
 
 // From the mollier diagram, at 0.1 bar and 0.85 quality
 parameter Real uf(unit="kJ/kg")=192               "Internal energy";
 parameter Real ufg(unit="kJ/kg")=2245             "Internal energy";
 parameter Real sf(unit="kJ/kg*K")=0.649           "Entropy";
 parameter Real sfg(unit="kJ/kg*K")=7.499          "Entropy";
 parameter Real hf(unit="kJ/kg")=192               "Enthalpy";
 parameter Real hfg(unit="kJ/kg")=2392             "Enthalpy";
 parameter Real vf(unit="m^3/kg")=0.001010         "Specific volume";
 parameter Real vfg(unit="m^3/kg")=14.67           "Specific volume";
 parameter Real x(unit="")=0.85                    "Dryness fraction";
 

 // Equations

equation
u=uf+x*ufg;
s=sf+x*sfg;
h=hf+x*hfg;
v=vf+x*vfg;
fhi1=h0-T0*s0;
fhi2=u+p0*v-T0*s;
fhi=m*(fhi2-fhi1);

end Ex9_16_c;
//===============================================================================================


model Ex9_16_d


// Variables

Real fhi(unit="kJ")                         "Total exergy of the system";


// Parameters
  parameter Real m(unit="kg")=3             "Rate of mass of steam received by turbine";
  parameter Real T0(unit="K")=300          "Surrounding temperature";
  
 // From the mollier diagram,at the dead state of 1 bar and 300 K
 
 parameter Real u0(unit="kJ/kg")=113.1                 "Internal energy";
 parameter Real s0(unit="kJ/kg*K")=0.0395               "Entropy";
 parameter Real h0(unit="kJ/kg")=113.2                 "Enthalpy of gas";
 parameter Real v0(unit="m^3/kg")=0.001005             "specific volume";
 
 // From the mollier diagram, at 100 kPa and -10 degree celsius
 
 
 parameter Real s(unit="kJ/kg*K")=-1.289                "Entropy";
 parameter Real h(unit="kJ/kg")=-354.1                  "Enthalpy";
 
 // Equations

equation

fhi=m*((h-h0)-T0*(s-s0));
//The  answer provided in the textbook is wrong.

//Book answer is wrong.
end Ex9_16_d;

end Ex9_16;
