model Ex9_18

// Variables
Real b1(unit="kJ/kg")                            "";
Real b2(unit="kJ/kg")                            "";
Real Q_max(unit="kJ/h")                          "Maximum cooling rate";


// Parameters
  parameter Real w(unit="kg/h")=50                   "Steam flow rate";
  parameter Real T0(unit="K")=318                    "Surrounding temperature";
  parameter Real T(unit="K")=296                     "Temperature";
  parameter Real h1(unit="kJ/kg")=2746.4             "Enthalpy at state 1";
  parameter Real h2(unit="kJ/kg")=419                "Enthalpy at state 2";
  parameter Real s1(unit="kJ/kg*K")=6.8387           "Entropy at state 1";
  parameter Real s2(unit="kJ/kg*K")=1.3071           "Entropy at state 2";
  
 // Equations

equation

b1=h1-T0*s1;
b2=h2-T0*s2;
Q_max=w*(b1-b2)/((T0/T)-1);


end Ex9_18;
