model Ex9_5

// Variables
Real Vf(unit="m^3")                           "Volume of liquid";
Real Vg(unit="m^3")                           "Volume of vapour";
Real mg(unit="kg")                            "Mass of vapour";
Real m(unit="kg")                             "Total mass of mixture";
Real x(unit="")                               "Quality of mixture";
Real v(unit="m^3/kg")                         "Spcific volume";
Real h(unit="kJ/kg")                          "Enthalpy";
Real s(unit="kJ/kg*K")                        "Entropy";
Real u(unit="kJ/kg")                          "Internal energy";
Real U(unit="kJ/kg")                          "Internal energy";


// Parameters
 // According to steam table,250 degree celsius and 3.973 MPa
 parameter Real mf(unit="kg")=9                          "Mass of fluid";
 parameter Real vg(unit="m^3/kg")=0.05013                "Specific volume of gas"; 
 parameter Real vf(unit="m^3/kg")=0.0012512              "Specific volume of liquid";
 parameter Real sfg(unit="kJ/kg*K")=3.2802               "Entropy";
 parameter Real sf(unit="kJ/kg*K")=2.7927                "Entropy of liquid";
 parameter Real hfg(unit="kJ/kg")=1716.2                 "Enthalpy";
 parameter Real hf(unit="kJ/kg")=1085.36                 "Enthalpy of liquid";
 parameter Real V(unit="m^3")=0.04                       "volume of vessel";
 parameter Real uf(unit="kJ/kg")=1080.39                 "Internal energy of liquid";
 parameter Real ufg(unit="kJ/kg")=1522.0                 "Internal energy";
 parameter Real p(unit="kPa")=3.973e03                   "Saturated pressure";
 
 // Equations

equation
Vf=mf*vf;
Vg=V-Vf;
mg=Vg/vg;
m=mf+mg;
x=mg/(mf+mg);
v=vf+x*(vg-vf);
h=hf+x*hfg;
s=sf+x*sfg;
u=h-p*v;
U=uf+x*ufg;
//Rounding off error.
// Given answer for U in the book is wrong.

end Ex9_5;
