class Ex11_10
parameter Real rho(unit="ft")=2500"radius of the highway";
parameter Real v_0(unit="ft/s")=60*(5280/3600)"initial velocity of the motorist";
parameter Real v_f(unit="ft/s")=45*(5280/3600)"final velocity of the motorist";
parameter Real t(unit="s")=8"given time";

Real a_t(unit="ft/s^2")"tangential component of acceleration";
Real a_n(unit="ft/s^2")"normal component of acceleration";
Real a(unit="ft/s^2")"acceleration of the motorist";
Real alpha(unit="rad")"acceleration's direction in radian unit";
Real alpha_deg(unit="deg")"acceleration's direction in degree unit";
equation
a_t=(v_f-v_0)/t;
a_n=v_0^2/rho;
tan(alpha)=a_n/abs(a_t);
a=a_n/sin(alpha);
alpha_deg=Modelica.SIunits.Conversions.to_deg(alpha);
end Ex11_10;
