class Ex13_17
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";

parameter Real m_A(unit="kg")=30"mass of the block";
Real W_A(unit="N")"weight of the block";
parameter Real v_A1(unit="m/s")=0"initial velocity of the block";
parameter Real y(unit="m")=2"initial distance between block and pan";
Real T_1(unit="J")"initial kinetic energy of the block";
Real V_1(unit="J")"initial gravitational potential energy of the block";
Real v_A2(unit="m/s")"velocity of the block just before touching the pan";
Real T_2(unit="J")"kinetic energy of the block just before touching the pan";
Real V_2(unit="J")"gravitational potential energy of the block just before touching the pan";

parameter Real m_B(unit="kg")=10"mass of the pan";
Real W_B(unit="N")"weight of the pan";
parameter Real v_B2(unit="m/s")=0"initial velocity of the pan";
Real v_3(unit="m/s")"velocity of the system after hitting";

parameter Real k(unit="N/m")=20*10^3"constant of spring";
Real x_3(unit="m")"initial deflection of the spring";
Real x_4(unit="m",start=0.20)"total maximum deflection of the spring";
Real h(unit="m")"displacement of the pan";

Real T_3(unit="J")"kinetic energy of the system just after hitting";
Real V_g3(unit="J")"gravitational potential energy of the system just before hitting";
Real V_e3(unit="J")"elastic potential energy of the spring just before hitting";
Real V_3(unit="J")"potential energy of the system just  before hitting";

parameter Real T_4(unit="J")=0"kinetic energy of the system at the maximum deflection";
Real V_g4(unit="J")"gravitational potential energy of the system at the maximum deflection";
Real V_e4(unit="J")"elastic potential energy of the spring at the maximum deflection";
Real V_4(unit="J")"potential energy of the system at the maximum deflection";

equation
W_A=m_A*g;
W_B=m_B*g;

T_1=(1/2)*m_A*v_A1^2;
V_1=W_A*y;
T_2=(1/2)*m_A*v_A2^2;
V_2=0;
T_1+V_1=T_2+V_2;

m_A*v_A2+m_B*v_B2=(m_A+m_B)*v_3;

x_3=W_B/k;
T_3=(1/2)*(m_A+m_B)*v_3^2;
V_g3=0;
V_e3=(1/2)*k*x_3^2;
V_3=V_g3+V_e3;

V_g4=(W_A+W_B)*(-h);
V_e4=(1/2)*k*x_4^2;
V_4=V_g4+V_e4;

h=x_4-x_3;

T_3+V_3=T_4+V_4;

end Ex13_17;
