class Ex13_2
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";

parameter Real m_A(unit="kg")=200"mass of the block A";
Real W_A(unit="N")"weight of the block A";
Real v_1A(unit="m/s")"initial velocity of the block A"; 
Real T_1A(unit="N.m")"initial kinetic energy of the block A"; 
Real v_2A(unit="m/s",start=0.001)"final velocity of the block A"; 
Real T_2A(unit="N.m")"final kinetic energy of the block A"; 

Real U_12A(unit="N.m")"work done on the block A";
Real U_12B(unit="N.m")"work done on the block B";

parameter Real m_B(unit="kg")=300"mass of the block B";
Real W_B(unit="N")"weight of the block B";
Real v_1B(unit="m/s")"initial velocity of the block B"; 
Real T_1B(unit="N.m")"initial kinetic energy of the block B"; 
Real v_2B(unit="m/s")"final velocity of the block B"; 
Real T_2B(unit="N.m")"final kinetic energy of the block B"; 

Real F_A(unit="N")"friction force on the block A";
Real F_C(unit="N")"force exerted by the cable";
parameter Real mu_k=0.25"coefficient of kinetic friction"; 
parameter Real x(unit="m")=2"distance covered by blocks";
equation
W_A=m_A*g;
F_A=mu_k*W_A;

v_1A=0;
T_1A=(1/2)*m_A*v_1A^2;
U_12A=F_C*x-F_A*x;
T_2A=(1/2)*m_A*v_2A^2;
T_1A+U_12A=T_2A;

v_2A=v_2B;

W_B=m_B*g;
v_1B=0;
T_1B=(1/2)*m_B*v_1B^2;
U_12B=W_B*x-F_C*x;
T_2B=(1/2)*m_B*v_2B^2;
T_1B+U_12B=T_2B;

end Ex13_2;
