class Ex13_6
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";

parameter Real k(unit="lb/in")=3"spring constant";
parameter Real W(unit="lb")=20"weight of the collar";
parameter Real x_0(unit="in")=4"undeformed length of the spring";
parameter Real x_01(unit="in")=8"length of the spring at position 1";
Real x_1(unit="in")"1st elongation of the spring";
Real V_e1(unit="in.lb")"elastic potential energy of the spring at position 1";
parameter Real V_g1(unit="in.lb")=0"gravitational potential energy of the block at position 1";
Real V_1(unit="in.lb")"total poential energy of the system at position 1";
parameter Real T_1(unit="in.lb")=0"kinetic energy of the block at position 1";

parameter Real y(unit="in")=-6"final collar position";
Real x_02(unit="in")"length of the spring at position 2";
Real x_2(unit="in")"2nd elongation of the spring";
Real V_e2(unit="in.lb")"elastic potential energy of the spring at position 2";
Real V_g2(unit="in.lb")"gravitational potential energy of the block at position 2";
Real V_2(unit="in.lb")"total poential energy of the system at position 2";
Real T_2(unit="in.lb")"kinetic energy of the block at position 2";
Real v_2_inps(unit="in/s")"velocity of the block at position 2 in inch per second";
Real v_2_ftps(unit="ft/s")"velocity of the block at position 2 in foot per second";
equation
x_1=x_01-x_0;
V_e1=(1/2)*k*x_1^2;
V_1=V_e1+V_g1;

x_02=sqrt(x_01^2+y^2);
x_2=x_02-x_0;
V_e2=(1/2)*k*x_2^2;
V_g2=W*y;
V_2=V_e2+V_g2;
T_2=(1/2)*(W/g)*v_2_inps^2;
v_2_inps=sqrt((1/((1/2)*(W/g)))*(T_1+V_1-V_2));
v_2_ftps=v_2_inps/12;
/*The  answer provided in the textbook is wrong*/
end Ex13_6;
