class Ex13_9
parameter Real pi=Modelica.Constants.pi;
parameter Real R(unit="m")=6370*10^3"radius of the earth";
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real v_0(unit="m/s")=36900*(1000/3600)"launching velocity of the satellite";
parameter Real z_0(unit="m")=500*10^3"launching altitude of the satellite";
Real GM(unit="m^3/s^2");
Real r_0(unit="m")"launching distance of the satellite from center of earth";
Real r_1(unit="m",start=0.001)"maximum distance of the satellite from center of earth";
Real z_1(unit="m")"maximum altitude of the satellite";

parameter Real z_min(unit="m")=200*10^3"minimum altitude of the satellite";
Real r_min(unit="m")"minimum distance of the satellite from center of earth";
Real v_max(unit="m/s")"maximum velocity of the satellite";
Real phi_0(unit="rad")"maximum allowable error in the direction of launching in radian unit";
Real phi_0_deg_1(unit="deg")"maximum allowable error in the direction of launching in degree unit(positive value)";
Real phi_0_deg_2(unit="deg")"maximum allowable error in the direction of launching in degree unit(negative value)";
equation
r_0=R+z_0;
GM=g*R^2;
1+r_0/r_1=(2*GM)/(r_0*v_0^2);
r_1=R+z_1;

r_min=R+z_min;
(1/2)*v_0^2-GM/r_0=(1/2)*v_max^2-GM/r_min;
r_0*v_0*sin(phi_0)=r_min*v_max;

phi_0_deg_1=90-phi_0*(180/pi);
phi_0_deg_2=-(90-phi_0*(180/pi));
/*The  answer may slightly vary due to  rounding off values*/
end Ex13_9;
