class Ex14_2
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";

parameter Real W(unit="lb")=20"weight of the projectile";
parameter Real W_A(unit="lb")=5"weight of the part A";
parameter Real W_B(unit="lb")=15"weight of the part A";

parameter Real theta_A_deg(unit="deg")=45"direction of the part A in degree unit";
Real theta_A(unit="rad")"direction of the part A in radian unit";
parameter Real theta_B_deg(unit="deg")=30"direction of the part B in degree unit";
Real theta_B(unit="rad")"direction of the part B in radian unit";

parameter Real v_0(unit="ft/s")=100"velocity of the projectile";
Real v_A(unit="ft/s")"magnitude of the velocity of the part A";
Real v_B(unit="ft/s")"magnitude of the velocity of the part B";
equation
theta_A=Modelica.SIunits.Conversions.from_deg(theta_A_deg);
theta_B=Modelica.SIunits.Conversions.from_deg(theta_B_deg);
(W_A/g)*v_A*cos(theta_A)+(W_B/g)*v_B*cos(theta_B)=(W/g)*v_0;
(W_A/g)*v_A*sin(theta_A)-(W_B/g)*v_B*sin(theta_B)=0;

end Ex14_2;
