class Ex15_1
/*Number-a*/
parameter Real pi=Modelica.Constants.pi;

parameter Real t(unit="s")=2"given time";

parameter Real r_inner(unit="in")=3"radius of inner pully";
parameter Real r_outer(unit="in")=5"radius of outer pully";
parameter Real a_C(unit="in/s^2")=9"acceleration of point C";
parameter Real v_C0(unit="in/s")=12"initial velocity of point C";

Real v_D0(unit="in/s")"initial velocity of point D";
Real a_Dt(unit="in/s^2")"tangential component of acceleration of point D";

Real w_0(unit="rad/s")"initial angular velocity of the pully";
Real alpha(unit="rad/s^2")"angular acceleration of the pully";
Real w(unit="rad/s")"angular velocity of the pully after 2 second";
Real theta(unit="rad")"angular position of the pully after 2 second";
Real N(unit="rev")"number of revolution";

/*Number-b*/
Real v_B(unit="in/s")"velocity of the load B after 2 second";
Real dy_B(unit="in")"change in position of the load after 2 second";

/*Number-c*/
Real a_Dn(unit="in/s^2")"normal component of acceleration of point D";
Real a_D(unit="in/s^2")"magnitude of the acceleration of point D at 0 second";
Real phi(unit="rad")"direction of the acceleration of point D at 0 second in radian unit";
Real phi_deg(unit="deg")"direction of the acceleration of point D at 0 second in degree unit";
equation
/*Number-a*/
v_D0=v_C0;
a_Dt=a_C;

v_D0=r_inner*w_0;
a_Dt=r_inner*alpha;

w=w_0+alpha*t;
theta=w_0*t+(1/2)*alpha*t^2;
N=theta/(2*pi);

/*Number-b*/
v_B=r_outer*w;
dy_B=r_outer*theta;

/*Number-c*/
a_Dn=r_inner*w_0^2;
tan(phi)=a_Dn/a_Dt;
phi_deg=Modelica.SIunits.Conversions.to_deg(phi);
a_D*sin(phi)=a_Dn;

end Ex15_1;
