class Ex15_13
parameter Real omega[3](each unit="rad/s")={0,-20,0}"angular velocity of the rod";
parameter Real omega_dot[3](each unit="rad/s^2")={0,-200,0}"angular acceleration of the rod";
parameter Real OD(unit="in")=8"position of the collar";
parameter Real theta_deg(unit="deg")=30"angular position of the rod in degree unit";
Real theta(unit="deg")"angular position of the rod in radian unit";
Real r[3](each unit="in")"position vector of the collar";
parameter Real v_DF_mag(unit="in/s")=50"magnitude of the velocity of the collar w.r.t. rod";
Real v_DF[3](each unit="in/s")"velocity of the collar w.r.t. rod";
parameter Real a_DF_mag(unit="in/s^2")=600"magnitude of the acceleration of the collar w.r.t. rod";
Real a_DF[3](each unit="in/s^2")"acceleration of the collar w.r.t. rod";
Real v_D_das[3](each unit="in/s")"velocity of the point D_das";
Real a_D_das[3](each unit="in/s^2")"aceleration of the point D_das";
Real v_D[3](each unit="in/s")"velocity of the collar";
Real a_D[3](each unit="in/s^2")"aceleration of the pcollar";
Real a_C[3](each unit="in/s^2")"Coriolis aceleration";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
r=OD*{sin(theta),cos(theta),0};
v_D_das=cross(omega,r);
v_DF=v_DF_mag*{sin(theta),cos(theta),0};
v_D=v_D_das+v_DF;

a_D_das=cross(omega_dot,r)+cross(omega,(cross(omega,r)));
a_DF=a_DF_mag*{sin(theta),cos(theta),0};
a_C=2*cross(omega,v_DF);
a_D=a_D_das+a_DF+a_C;
/*The  answer may slightly vary due to  rounding off values*/
end Ex15_13;
