class Ex15_3
parameter Real pi=Modelica.Constants.pi;

parameter Real w_AB(unit="rad/s")=2000*((2*pi)/60)"angular velocity of the crank AB";
parameter Real r(unit="in")=3"length of AB";
parameter Real l(unit="in")=8"length of BD";
parameter Real theta_AB_deg(unit="deg")=40"angle of AB w.r.t. horizontal in degree unit";
Real theta_AB(unit="rad")"angle of AB w.r.t. horizontal in radian unit";
Real v_B(unit="in/s")"velocity of point B";
Real theta_B(unit="rad")"direction of the vector v_B w.r.t. horizontal";
Real beta(unit="rad")"angle of BD w.r.t. horizontal";
Real v_D(unit="in/s")"absolute velocity of point D";
Real v_P(unit="in/s")"absolute velocity of point P";
Real v_DB(unit="in/s")"velocity of point D w.r.t B";
Real w_BD(unit="rad/s")"angular velocity of the BD";
equation
theta_AB=Modelica.SIunits.Conversions.from_deg(theta_AB_deg);
v_B=r*w_AB;
theta_B=pi-(pi/2+theta_AB);
sin(theta_AB)/l=sin(beta)/r;
v_D/sin(53.9*(pi/180))=v_B/sin(76.1*(pi/180));
v_P=v_D;
v_DB/sin(theta_B)=v_B/sin(76.1*(pi/180));
v_DB=l*w_BD;
end Ex15_3;
