class Ex15_8
parameter Real r_B[3](each unit="m")={8,14,0}"position of B";
parameter Real r_D[3](each unit="m")={-17,17,0}"position of D";
parameter Real r_DB[3](each unit="m")={12,3,0}"position of D w.r.t B";

parameter Real w_AB_k(unit="rad/s")=20"k-component of the angular velocity of the link AB"; 
Real w_AB[3](each unit="rad/s")"angular velocity of the link AB";
Real w_BD_k(unit="rad/s")"k-component of the angular velocity of the link BD"; 
Real w_BD[3](each unit="rad/s")"angular velocity of the link BD";
Real w_DE_k(unit="rad/s")"k-component of the angular velocity of the link DE"; 
Real w_DE[3](each unit="rad/s")"angular velocity of the link DE";

Real v_D_left[3](each unit="m/s")"left hand side of velocity equation of point D";
Real v_D_right[3](each unit="m/s")"right hand side of velocity equation of point D";
Real v_B[3](each unit="m/s")"velocity of point B";
Real v_DB[3](each unit="m/s")"velocity of point D w.r.t B";

parameter Real alpha_AB_k(unit="rad/s^2")=0"k-component of the angular acceleration of the link AB"; 
Real alpha_AB[3](each unit="rad/s^2")"angular acceleration of the link AB";
Real alpha_BD_k(unit="rad/s^2")"k-component of the angular acceleration of the link BD"; 
Real alpha_BD[3](each unit="rad/s^2")"angular acceleration of the link BD";
Real alpha_DE_k(unit="rad/s^2")"k-component of the angular acceleration of the link DE"; 
Real alpha_DE[3](each unit="rad/s^2")"angular acceleration of the link DE";

Real a_D_left[3](each unit="m/s^2")"left hand side of acceleration equation of point D";
Real a_D_right[3](each unit="m/s^2")"right hand side of acceleration equation of point D";
Real a_B[3](each unit="m/s^2")"acceleration of point B";
Real a_DB[3](each unit="m/s^2")"acceleration of point D w.r.t B";
equation
w_AB={0,0,w_AB_k};
w_BD={0,0,w_BD_k};
w_DE={0,0,w_DE_k};

v_B=cross(w_AB,r_B);
v_DB=cross(w_BD,r_DB);
v_D_left=cross(w_DE,r_D);
v_D_right=v_B+v_DB;
v_D_left[1]=v_D_right[1];
v_D_left[2]=v_D_right[2];

alpha_AB={0,0,alpha_AB_k};
alpha_BD={0,0,alpha_BD_k};
alpha_DE={0,0,alpha_DE_k};

a_B=cross(alpha_AB,r_B)-w_AB_k^2*r_B;
a_DB=cross(alpha_BD,r_DB)-w_BD_k^2*r_DB;
a_D_left=cross(alpha_DE,r_D)-w_DE_k^2*r_D;
a_D_right=a_B+a_DB;
a_D_left[1]=a_D_right[1];
a_D_left[2]=a_D_right[2];
/*The  answer may slightly vary due to  rounding off values*/
end Ex15_8;
