class Ex17_1
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W(unit="lb")=240"weight of the block";
Real m(unit="lbm")"mass of the block";
parameter Real r(unit="ft")=1.25"radius of the drum";
parameter Real I_bar(unit="lb.ft.s^2")=10.5"moment of inertia of the drum and fly wheel";
parameter Real v_1(unit="ft/s")=6"velocity of the block at position 1";
parameter Real M(unit="lb.ft")=60"applied couple";
parameter Real s_1(unit="ft")=0"displacement of the block at position 1";
Real w_1(unit="rad/s")"angular velocity of the wheel at position 1";
Real T_1(unit="ft.lb")"kinetic energy of the system at position 1";
parameter Real theta_1(unit="rad")=0"angular position of the wheel at position 1";
Real U_12(unit="ft.lb")"work done on the system";

Real v_2(unit="ft/s",start=0.001)"velocity of the block at position 2";
parameter Real s_2(unit="ft")=4"displacement of the block at position 2";
Real w_2(unit="rad/s")"angular velocity of the wheel at position 2";
Real T_2(unit="ft.lb")"kinetic energy of the system at position 2";
Real theta_2(unit="rad")"angular position of the wheel at position 2";

equation
m=W/g;
w_1=v_1/r;
T_1=(1/2)*m*v_1^2+(1/2)*I_bar*w_1^2;

w_2=v_2/r;
T_2=(1/2)*m*v_2^2+(1/2)*I_bar*w_2^2;
theta_2=s_2/r;
U_12=W*(s_2-s_1)-M*(theta_2-theta_1);
T_1+U_12=T_2;
end Ex17_1;
