class Ex17_10
parameter Real L(unit="m")=1.2"length of the rod";
parameter Real AG(unit="m")=0.6"CG of the rod";
parameter Real m_s(unit="kg")=2"mass of the sphere";
parameter Real m_R(unit="kg")=8"mass of the rod";

parameter Real v_s(unit="m/s")=5"initial velocity of the ball";
Real v_s_das(unit="m/s")"final velocity of the ball";
parameter Real v_B(unit="m/s")=0"initial velocity of the rod at B";
Real v_B_das(unit="m/s")"final velocity of the rod at B";
Real v_R_das(unit="m/s")"final velocity of the rod at G";
Real w_das(unit="rad/s")"angular velocity of the rod after hitting";
Real I_bar(unit="kg.m^2")"moment of inertia of the rod";
Real e=0.80"coefficient of restitution";
equation
I_bar=(1/12)*m_R*L^2;
v_R_das=AG*w_das;
m_s*v_s*L=m_s*v_s_das*L+m_R*v_R_das*AG+I_bar*w_das;
v_B_das=L*w_das;
v_B_das-v_s_das=e*(v_s-v_B);
end Ex17_10;
