class Ex17_4
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W(unit="lb")=30"weight of the bar";
Real m(unit="lbm")"mass of the bar";
parameter Real AB(unit="ft")=5"length of the rod";
parameter Real OB(unit="ft")=1"length of the OB";
Real r(unit="ft")"position of the center of gravity w.r.t O";
parameter Real k(unit="lb/ft")=1800*12"spring constant";
parameter Real x_1(unit="ft")=1/12"compressed length of the spring";

Real V_e1(unit="ft.lb")"elastic potential energy of the spring at position 1";
parameter Real V_g1(unit="ft.lb")=0"gravitational potential energy of the bar at position 1";
Real V_1(unit="ft.lb")"total potential energy of the system at position 1"; 
parameter Real T_1(unit="ft.lb")=0"total kinetic energy of the system at position 1";

parameter Real V_e2(unit="ft.lb")=0"elastic potential energy of the spring at position 2";
Real V_g2(unit="ft.lb")"gravitational potential energy of the bar at position 2";
Real V_2(unit="ft.lb")"total potential energy of the system at position 2";
Real I_bar(unit="lb.ft.s^2")"moment of inertia of the bar"; 
Real T_2(unit="ft.lb")"total kinetic energy of the system at position 2";
Real w_2(unit="rad/s",start=0.001)"angular velocity of the rod at position 2";
Real v_2(unit="ft/s")"velocity of the rod at position 2";

Real a_n(unit="ft/s^2")"normal component of the acceleration of the center G at position 2";
Real a_t(unit="ft/s^2")"tangential component of the acceleration of the center G at position 2";
Real alpha(unit="rad/s^2")"angular acceleration of the rod at position 2";
Real R_x(unit="lb")"x-component of the reaction at pivot O at position 2";
Real R_y(unit="lb")"y-component of the reaction at pivot O at position 2";
equation
m=W/g;
r=(AB/2-OB);
V_e1=(1/2)*k*x_1^2;
V_1=V_e1+V_g1;
V_g2=W*r;
V_2=V_e2+V_g2;
I_bar=(1/12)*m*AB^2;
v_2=r*w_2;
T_2=(1/2)*m*v_2^2+(1/2)*I_bar*w_2^2;
T_1+V_1=T_2+V_2;

a_n=r*w_2^2;
a_t=r*alpha;
I_bar*alpha+m*(r*alpha)*r=0;
R_x=m*(r*alpha);
R_y-W=-m*a_n;
end Ex17_4;
