class Ex19_5
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W_m(unit="lb")=350"weight of the motor";
Real m_m(unit="lbm")"mass of the motor";
parameter Real k(unit="lb/ft")=750*12"spring constant for a single spring";
Real k_t(unit="lb/ft")"total spring constant for a single spring";
Real p(unit="rad/s")"circular frequency of the free vibration of the motor in rad/s unit";
Real p_rpm(unit="rpm")"circular frequency of the free vibration of the motor in rpm unit";
Real p_resonance(unit="rpm")"resonance speed";

parameter Real W_u(unit="oz")=1"weight of the unblance part";
Real m_u(unit="lbm")"mass of the unblance part";
parameter Real w(unit="rad/s")=1200*((2*pi)/60)"given motor speed";
parameter Real r(unit="ft")=6/12"position of the unblance part";
Real P_m(unit="lb")"magnitude of the centrifugal force";
Real delta(unit="in")"static deflection";
Real x_m(unit="in")"amplitude of the vibration of the motor";
equation
m_m=W_m/g;
k_t=4*k;
p=sqrt(k_t/m_m);
p_rpm=p*(60/(2*pi));
p_resonance=p_rpm;
m_u=W_u/(16*g);
P_m=m_u*r*w^2;
delta=P_m/(k_t/12);
x_m=(P_m/(k_t/12))/(1-(w/p)^2);
/*The  answer may slightly vary due to  rounding off values*/


end Ex19_5;
