class Ex11_5
parameter Real xA_xo(unit="in")=8"distance between initial position and final position of A";
parameter Real v_A(unit="in/s")=12"velocity of A at position L";
parameter Real v_A_0(unit="in/s")=0"initial velocity of A";
Real a_A(unit="in/s^2")"acceleration of A at position L";
Real t(unit="s")"time required for A to reach at position L";

parameter Real v_D(unit="in/s")=3"velocity of D";
parameter Real a_D(unit="in/s^2")=0"acceleration of D";
Real xD_xo(unit="in")"distance between initial position and final position of D";

Real xB_xo(unit="in")"distance between initial position and final position of B";
Real v_B(unit="in/s")"velocity of B when A passes point L";
Real a_B(unit="in/s^2")"acceleration of B when A passes point L";
equation
v_A^2=v_A_0^2+2*a_A*xA_xo;
v_A=v_A_0+a_A*t;
xD_xo=v_D*t;
xA_xo+xB_xo+2*xD_xo=0;
v_A+2*v_D+v_B=0;
a_A+2*a_D+a_B=0;
end Ex11_5;
