class Ex12_1
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W(unit="lb")=200"weight of the block";
parameter Real a(unit="ft/s^2")=10"acceleration of the block";
parameter Real mu_k=0.25"coefficient of the kinetic friction";
parameter Real theta_deg(unit="deg")=30"direction of applied force in degree unit";
Real theta(unit="rad")"direction of applied force in radian unit";
Real m(unit="lb.s^2/ft")"mass of the block";
Real N(unit="lb")"normal force on the block";
Real F(unit="lb")"fricition force on the block";
Real P(unit="lb")"applied force on the block";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
m=W/g;
F=mu_k*N;
P*cos(theta)-F=m*a;
N-P*sin(theta)-W=0;
/*The  answer may slightly vary due to  rounding off values*/
end Ex12_1;
