class Ex12_4
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";

parameter Real theta_deg(unit="deg")=30"angle of the wedge in degree unit";
Real theta(unit="rad")"angle of the wedge in radian unit";

parameter Real W_A(unit="lb")=30"weight of the wedge A";
Real m_A(unit="lb.s^2/ft")"mass of the wedge A";
Real a_A(unit="ft/s^2")"acceleration of the wedge A";

parameter Real W_B(unit="lb")=12"weight of the block B";
Real m_B(unit="lb.s^2/ft")"mass of the block B";
Real a_B(unit="ft/s^2")"acceleration of the block B";

Real N_1(unit="lb")"force exerted on the wedge A by the block B";

Real a_BA(unit="ft/s^2")"acceleration of the block B w.r.t wedge A";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
m_A=W_A/g;
m_B=W_B/g;
a_B=a_A+a_BA;
N_1*sin(theta)=m_A*a_A;
-W_B*sin(theta)=m_B*a_A*cos(theta)-m_B*a_BA;
N_1-W_B*cos(theta)=-m_B*a_A*sin(theta);
end Ex12_4;
