class Ex12_9
parameter Real pi=Modelica.Constants.pi;
/*Number-a*/
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real R(unit="m")=6370*10^3"radius of the earth";
parameter Real h_0(unit="m")=500*10^3"altitude of the launched point";
parameter Real v_0(unit="m/s")=36900*(1000/3600)"velocity of the satellite at launched point";

Real r_0(unit="m")"distance between center of the earth and the launched point";
Real h(unit="m^2/s")"angular momentum per unit mass";
Real GM(unit="m^3/s^2");
parameter Real theta_0(unit="rad")=0"angular position of the launched point";
parameter Real theta_1(unit="rad")=pi"angular position of the maximum altitude";
Real C(unit="m^(-1)");
Real r_1(unit="m")"distance between center of the earth and the maximum altitude";
Real h_maximum(unit="m")"maximum altitude of the satellite";

/*Number-b*/
Real a(unit="m")"semi major axis";
Real b(unit="m")"semi minor axis";
Real tau(unit="s")"periodic time of the saellite";
equation
/*Number-a*/
r_0=h_0+R;
h=r_0*v_0;
GM=g*R^2;
1/r_0=GM/h^2+C*cos(theta_0);
1/r_1=GM/h^2+C*cos(theta_1);
h_maximum=r_1-R;

/*Number-b*/
a=(1/2)*(r_0+r_1);
b=sqrt(r_0*r_1);
tau=(2*pi*a*b)/h;
/*The  answer may slightly vary due to  rounding off values*/
end Ex12_9;
