class Ex13_11
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W(unit="oz")=4"weight of the ball";
parameter Real v_1(unit="ft/s")=80"initial velocity of the ball";
parameter Real v_2(unit="ft/s")=120"final velocity of the ball";
parameter Real dt(unit="s")=0.015"contact duration";
Real m(unit="lbm")"mass of the automobile";
parameter Real theta_deg(unit="deg")=40"direction of the ball hitting in degree unit";
Real theta(unit="rad")"direction of the ball hitting in radian unit";
Real F(unit="lb")"impulsive force";
Real F_x(unit="lb")"x-component of the impulsive force";
Real F_y(unit="lb")"y-component of the impulsive force";
Real alpha_deg(unit="deg")"direction of the impulsive force in degree unit";
Real alpha(unit="rad")"direction of the impulsive force in radian unit";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
m=(W/16)/g;
-m*v_1+F_x*dt=m*v_2*cos(theta);
F_y*dt=m*v_2*sin(theta);
F=sqrt(F_x^2+F_y^2);
alpha=atan(F_y/F_x);
alpha_deg=Modelica.SIunits.Conversions.to_deg(alpha);
end Ex13_11;
