class Ex13_3
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";

parameter Real m(unit="kg")=60"mass of the package";
Real W(unit="N")"weight of the package";
parameter Real v_1(unit="m/s")=2.5"velocity of the package at position 1"; 
Real T_1(unit="N.m")"kinetic energy of the package at position 1"; 
Real v_2(unit="m/s")"velocity of the package at position 2"; 
Real T_2(unit="N.m")"kinetic energy of the package at position 2"; 
Real v_3(unit="m/s")"velocity of the package at position 3"; 
Real T_3(unit="N.m")"kinetic energy of the package at position 3"; 

Real U_12f(unit="N.m")"work done on the package by friction force to come from 1 to 2";
Real U_12e(unit="N.m")"work done on the package by spring force to reach position 2";
Real U_12(unit="N.m")"total work done on the package to come from 1 to 2";
Real U_23(unit="N.m")"total work done on the package to come from 2 to 3";

parameter Real k(unit="N/m")=20*10^3"spring constant";
Real x_ps(unit="m")=600/1000"initial distance between package and spring";
Real x0(unit="m")=120/1000"initial compression length of the spring";
Real dx(unit="m")=40/1000"final compression length of the spring";
Real x(unit="m")"total dispalcement of the package";

Real F(unit="N")"friction force";
Real P_min(unit="N")"minimum force developed by spring";
Real P_max(unit="N")"maximum force developed by spring";
Real mu_k"coefficient of kinetic friction";
equation
W=m*g;
v_2=0;
x=x_ps+dx;

T_1=(1/2)*m*v_1^2;
T_2=(1/2)*m*v_2^2;

F=mu_k*W;
U_12f=-F*x;

P_min=k*x0;
P_max=P_min+k*dx;
U_12e=-(1/2)*(P_min+P_max)*dx;

U_12=U_12f+U_12e;
T_1+U_12=T_2;

T_3=(1/2)*m*v_3^2;
U_23=U_12f-U_12e;
T_2+U_23=T_3;
/*The  answer may slightly vary due to  rounding off values*/
end Ex13_3;
