class Ex13_4
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";

parameter Real W(unit="lb")=2000"weight of the car";
Real m(unit="lbm")"mass of the car";

parameter Real d_12(unit="ft")=40"distance between point 1 and 2";
parameter Real d_23(unit="ft")=15"distance between point 2 and 3";
parameter Real rho_2(unit="ft")=20"radius of curvature at position 2";

parameter Real v_1(unit="ft/s")=0"velocity of the car at position 1"; 
Real T_1(unit="lb.ft")"kinetic energy of the car at position 1"; 
Real v_2(unit="ft/s")"velocity of the car at position 2"; 
Real T_2(unit="lb.ft")"kinetic energy of the car at position 2"; 
Real v_3(unit="ft/s")"velocity of the car at position 3"; 
Real T_3(unit="lb.ft")"kinetic energy of the car at position 3"; 

Real U_12(unit="lb.ft")"total work done on the car to come from 1 to 2";
Real U_13(unit="lb.ft")"total work done on the car to come from 1 to 3";

Real N(unit="lb")"force exerted by the track on the car at point 2";
Real N_3(unit="lb")"force exerted by the track on the car at point 3";
Real a_n2(unit="ft/s^2")"normal component of acceleration at point 2";
Real a_n3(unit="ft/s^2")"normal component of acceleration at point 3";
Real rho_3(unit="ft")"radius of curvature at position 3";
equation
m=W/g;

T_1=(1/2)*m*v_1^2;
T_2=(1/2)*m*v_2^2;

U_12=W*d_12;
T_1+U_12=T_2;

a_n2=v_2^2/rho_2;
-W+N=m*a_n2;

U_13=W*(d_12-d_23);
T_3=(1/2)*m*v_3^2;
T_1+U_13=T_3;

a_n3=v_3^2/rho_3;
N_3=0;
W+N_3=m*a_n3;

end Ex13_4;
