class Ex13_5
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";

parameter Real W_D(unit="lb")=600"weight of D";
parameter Real W_C(unit="lb")=800"weight of C";
Real m_D(unit="lbm")"mass of D";
Real m_C(unit="lbm")"mass of C";

/*Number-a*/
parameter Real v_D_a(unit="ft/s")=8"velocity of D for case a";
Real T_a(unit="lb")"tension in the cable attested with block C for case a";
Real F_a(unit="lb")"tension in the cable attested with motor for case a";
Real P_a_fps(unit="ft.lb/s")"power developed for case a in fps unit";
Real P_a_hp(unit="hp")"power developed for case a in hp unit";

/*Number-b*/
parameter Real v_D_b(unit="ft/s")=8"velocity of D for case b";
parameter Real a_D_b(unit="ft/s^2")=2.5"acceleration of block D for case b";
Real a_C_b(unit="ft/s^2")"acceleration of block C for case b";


Real T_b(unit="lb")"tension in the cable attested with block C for case b";
Real F_b(unit="lb")"tension in the cable attested with motor for case b";
Real P_b_fps(unit="ft.lb/s")"power developed for case b in fps unit";
Real P_b_hp(unit="hp")"power developed for case b in hp unit";
equation
m_D=W_D/g;
m_C=W_C/g;

/*Number-a*/
2*T_a-W_C=0;
F_a+T_a-W_D=0;
P_a_fps=F_a*v_D_a;
P_a_hp=P_a_fps/550;

/*Number-b*/
a_C_b=a_D_b/2;
W_C-2*T_b=m_C*a_C_b;
F_b+T_b-W_D=m_D*a_D_b;
P_b_fps=F_b*v_D_b;
P_b_hp=P_b_fps/550;
end Ex13_5;
