class Ex14_3
parameter Real m(unit="kg")=200"mass of the vehicle";
parameter Real m_A(unit="kg")=100"mass of the part A";
parameter Real m_B(unit="kg")=60"mass of the part B";
parameter Real m_C(unit="kg")=40"mass of the part C";
parameter Real v_0[3](each unit="m/s")={150,0,0}"velocity of the vehicle";
parameter Real r[3](each unit="m")={150,450,-420}"position of the center of the vehicle after expolsion";
parameter Real r_A[3](each unit="m")={555,-180,240}"position of the part A of the vehicle after expolsion";
parameter Real r_B[3](each unit="m")={255,0,-120}"position of the part B of the vehicle after expolsion";
parameter Real r_C[3](each unit="m")={105,450,-420}"position of the part C of the vehicle after expolsion";

parameter Real v_A[3](each unit="m/s")={270,-120,160}"velocity of the part A";
Real v_Bx(unit="m/s")"x-component of the velocity of the part B";
Real v_Bz(unit="m/s")"z-component of the velocity of the part B";
Real v_B[3](each unit="m/s")"velocity of the part B";

Real v_Cx(unit="m/s")"x-component of the velocity of the part C";
Real v_Cy(unit="m/s")"y-component of the velocity of the part C";
Real v_Cz(unit="m/s")"z-component of the velocity of the part C";
Real v_C[3](each unit="m/s")"velocity of the part C";

Real L_left[3](each unit="kg.m/s")"left hand side of linear momentum equation";
Real L_right[3](each unit="kg.m/s")"right hand side of linear momentum equation";
Real H_left[3](each unit="kg.m^2/s")"left hand side of angular momentum equation";
Real H_right[3](each unit="kg.m^2/s")"right hand side of angular momentum equation";

equation
v_B={v_Bx,0,v_Bz};
v_C={v_Cx,v_Cy,v_Cz};

L_left=m*v_0;
L_right=m_A*v_A+m_B*v_B+m_C*v_C;
H_left={0,0,0};
H_right=cross(r_A,(m_A*v_A))+cross(r_B,(m_B*v_B))+cross(r_C,(m_C*v_C));

L_left[1]=L_right[1];
L_left[2]=L_right[2];
L_left[3]=L_right[3];

H_left[1]=H_right[1];
H_left[3]=H_right[3];
end Ex14_3;
