class Ex15_2
/*Number-a*/
parameter Real r_1(unit="m")=150/1000"radius of outer gear";
parameter Real r_2(unit="m")=100/1000"radius of inner gear";
parameter Real v_A_mag(unit="m/s")=1.2"mgnitude of velocity of the center A";
parameter Real v_A[3](each unit="m/s")=v_A_mag*{1,0,0}"velocity of the center A";

Real w_k(unit="rad/s")"k-component of the angular velocity of the gear"; 
Real w[3](each unit="rad/s")"angular velocity of the gear";

/*Number-b*/
parameter Real r_BA[3](each unit="m/s")={0,r_2,0}"position of the point B w.r.t A";
Real v_B[3](each unit="m/s")"velocity of the point B";
Real v_R[3](each unit="m/s")"velocity of the upper track R";


parameter Real r_DA[3](each unit="m/s")={-r_1,0,0}"position of the point D w.r.t A";
Real v_D[3](each unit="m/s")"velocity of the point D";
Real phi(unit="rad")"direction of the velocity of point D in radian unit";
Real phi_deg(unit="deg")"direction of the velocity of point D in degree unit";
equation
/*Number-a*/
v_A_mag=-r_1*w_k;
w={0,0,w_k};

/*Number-b*/
v_B=v_A+cross(w,r_BA);
v_R=v_B;
v_D=v_A+cross(w,r_DA);
tan(phi)=v_D[2]/v_D[1];
phi_deg=Modelica.SIunits.Conversions.to_deg(phi);
end Ex15_2;
