class Ex15_6
/*Number-a*/
parameter Real r_1(unit="m")=150/1000"radius of outer gear";
parameter Real r_2(unit="m")=100/1000"radius of inner gear";
parameter Real v_A_mag(unit="m/s")=1.2"mgnitude of velocity of the center A";
parameter Real v_A[3](each unit="m/s")=v_A_mag*{1,0,0}"velocity of the center A";
parameter Real a_A_mag(unit="m/s^2")=3"mgnitude of acceleration of the center A";
parameter Real a_A[3](each unit="m/s^2")=a_A_mag*{1,0,0}"acceleration of the center A";

Real w_k(unit="rad/s")"k-component of the angular velocity of the gear"; 
Real w[3](each unit="rad/s")"angular velocity of the gear";
Real alpha_k(unit="rad/s^2")"k-component of the angular acceleration of the gear"; 
Real alpha[3](each unit="rad/s^2")"angular acceleration of the gear";

/*Number-b*/
parameter Real r_BA[3](each unit="m")={0,r_2,0}"position of the point B w.r.t A";
Real a_B[3](each unit="m/s^2")"acceleration of the point B";
Real a_B_mag(unit="m/s^2")"magnitude of acceleration of the point B";
Real phi_B(unit="rad")"direction of the acceleration of point B in radian unit";
Real phi_B_deg(unit="deg")"direction of the acceleration of point B in degree unit";

parameter Real r_CA[3](each unit="m")={0,-r_1,0}"position of the point C w.r.t A";
Real a_C[3](each unit="m/s^2")"acceleration of the point C";
Real a_C_mag(unit="m/s^2")"magnitude of acceleration of the point C";

parameter Real r_DA[3](each unit="m")={-r_1,0,0}"position of the point D w.r.t A";
Real a_D[3](each unit="m/s^2")"acceleration of the point D";
Real a_D_mag(unit="m/s^2")"magnitude of acceleration of the point D";
Real phi_D(unit="rad")"direction of the acceleration of point D in radian unit";
Real phi_D_deg(unit="deg")"direction of the acceleration of point D in degree unit";
equation
/*Number-a*/
v_A_mag=-r_1*w_k;
w={0,0,w_k};
a_A_mag=-r_1*alpha_k;
alpha={0,0,alpha_k};

/*Number-b*/
a_B=a_A+cross(alpha,r_BA)-w_k^2*r_BA;
a_B_mag=Modelica.Math.Vectors.norm(a_B);
tan(phi_B)=abs(a_B[2])/a_B[1];
phi_B_deg=Modelica.SIunits.Conversions.to_deg(phi_B);

a_C=a_A+cross(alpha,r_CA)-w_k^2*r_CA;
a_C_mag=Modelica.Math.Vectors.norm(a_C);

a_D=a_A+cross(alpha,r_DA)-w_k^2*r_DA;
a_D_mag=Modelica.Math.Vectors.norm(a_D);
tan(phi_D)=a_D[2]/a_D[1];
phi_D_deg=Modelica.SIunits.Conversions.to_deg(phi_D);
end Ex15_6;
