class Ex16_6
/*Number-a*/
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real OB(unit="m")=400/1000"length of rod OB";
parameter Real r(unit="m")=120/1000"radius of the gear E";
parameter Real w(unit="rad/s")=8"angular velocity of the gear E";
parameter Real alpha(unit="rad/s^2")=40"angular acceleration of the gear E";
parameter Real m_OB(unit="kg")=3"mass of the rod OB";
parameter Real m_E(unit="kg")=4"mass of the gear E";
parameter Real k_bar_E(unit="m")=85/1000"radius of gyration of gear E";

Real a_OB_t(unit="m/s^2")"t-component of the acceleration of the mass center G_OB";
Real a_OB_n(unit="m/s^2")"n-component of the acceleration of the mass center G_OB";
Real W_E(unit="N")"weight of the gear E";
Real W_OB(unit="N")"weight of the rod OB";

Real I_E(unit="kg.m^2")"moment of inertia of the gear E";
Real I_OB(unit="kg.m^2")"moment of inertia of the rod OB";

Real F(unit="N")"force exerted by gear D";
Real R_x(unit="N")"x-component of the reaction at O";
Real R_y(unit="N")"y-component of the reaction at O";
equation
a_OB_t=(OB/2)*alpha;
a_OB_n=(OB/2)*w^2;
W_E=m_E*g;
W_OB=m_OB*g;

I_E=m_E*k_bar_E^2;
I_OB=(1/12)*m_OB*OB^2;
F*r=I_E*alpha+m_OB*a_OB_t*(OB/2)+I_OB*alpha;
R_x=m_OB*a_OB_t;
R_y-F-W_E-W_OB=m_OB*a_OB_n;
/*The  answer may slightly vary due to  rounding off values*/
end Ex16_6;
