class Ex16_9
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=50"mass of the wheel";
parameter Real r_in(unit="m")=60/1000"radius of the inner hub";
parameter Real r_out(unit="m")=100/1000"radius of the outer hub";
parameter Real P(unit="N")=200"applied force";
parameter Real mu_s=0.20"static friction coefficient";
parameter Real mu_k=0.15"kinetic friction coefficient";
parameter Real k_bar(unit="m")=70/1000"radius of gyration";
Real I_bar(unit="kg.m^2")"moment of inertia of the disk";

Real F_cal(unit="N")"calculated friction force";
Real F_max(unit="N")"maximum friction force";
Real F(unit="N")"actual friction force";

Real N(unit="N")"normal force";

Real alpha_cal(unit="rad/s^2")"calculated angular acceleration of the disk";
Real alpha(unit="rad/s^2")"actual angular acceleration of the disk";
Real a_cal(unit="m/s^2")"calculated acceleration of the disk";
Real a(unit="m/s^2")"actual  acceleration of the disk";
equation
a_cal=r_out*alpha_cal;
I_bar=m*k_bar^2;
P*r_in=m*a_cal+I_bar*alpha_cal;/*wrong value of r_in taken in the book*/
F_cal+P=m*a_cal;
N-m*g=0;

F_max=mu_s*N;
F=mu_k*N;
P-F=m*a;
F*r_out-P*r_in=I_bar*alpha;
/*the value of F_cal does not match with the book's value as wrong value of r_in is taken in the book*/
end Ex16_9;
