class Ex18_6
parameter Real pi=Modelica.Constants.pi;
parameter Real a(unit="m")=800/1000"radius of the disk";
parameter Real w_0(unit="rad/s")=60*((2*pi)/60)"initial angular velocity of the satellite";
parameter Real m_0_by_m=1/1000"ratio of mass of meteor and satellite";
parameter Real v_0(unit="m/s")=2000"velocity of the meteor w.r.t satellite";
Real w_x(unit="rad/s")"x-component of the angular velocity of the satellite after impact";
Real w_y(unit="rad/s")"y-component of the angular velocity of the satellite after impact";
Real w_z(unit="rad/s")"z-component of the angular velocity of the satellite after impact";
Real w(unit="rad/s")"angular velocity of the satellite after impact in radian/s unit";
Real w_rpm(unit="rpm")"angular velocity of the satellite after impact in rpm unit";
Real gama(unit="rad")"direction of angular velocity in radian unit";
Real gama_deg(unit="deg")"direction of angular velocity in degree unit";
Real theta(unit="rad")"direction of the precession axis in radian unit";
Real theta_deg(unit="deg")"direction of the precession axis in degree unit";
Real phi_dot_rad(unit="rad/s")"rates of precession in radian/s unit";
Real phi_dot_rpm(unit="rpm")"rates of precession in rpm unit";
Real psi_dot_rad(unit="rad/s")"rates of spin in radian/s unit";
Real psi_dot_rpm(unit="rpm")"rates of spin in rpm unit";
equation
w_x=-(4/5)*((m_0_by_m*v_0)/a);
w_y=0;
w_z=w_0;
w=sqrt(w_x^2+w_y^2+w_z^2);
w_rpm=w*(60/(2*pi));

tan(gama)=-w_x/w_z;
gama_deg=Modelica.SIunits.Conversions.to_deg(gama);

tan(theta)=2*((m_0_by_m*v_0)/(a*w_0));
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);

w/sin(theta)=phi_dot_rad/sin(gama);
phi_dot_rpm=phi_dot_rad*(60/(2*pi));

w/sin(theta)=psi_dot_rad/sin(theta-gama);
psi_dot_rpm=psi_dot_rad*(60/(2*pi));
/*The  answer may slightly vary due to  rounding off values*/
end Ex18_6;
