class Ex11_12
/*StopTime should be taken exactly 2 second to simulate the result*/

parameter Real pi=Modelica.Constants.pi;

parameter Real theta_f_deg(unit="deg")=30"given rotation of the arm OA in degree unit";
Real theta_f_rad(unit="rad")"given rotation of the arm OA in radian unit";

Real theta(unit="rad")"angular position of the arm OA";
Real theta_dot(unit="rad/s")"1st derivative of the angular position of the arm OA";
Real theta_ddot(unit="rad/s^2")"2nd derivative of the angular position of the arm OA";

Real r(unit="m")"radial position of the collar B";
Real r_dot(unit="m/s")"1st derivative of the radial position of the collar B";
Real r_ddot(unit="m/s^2")"2nd derivative of the radial position of the collar B";

Real v_r(unit="m/s")"radial velocity of the collar B";
Real v_theta(unit="m/s")" normal component of velocity of the collar B";
Real v(unit="m/s")"total velocity of the collar B";

Real a_r(unit="m/s^2")"radial acceleration of the collar B";
Real a_theta(unit="m/s^2")" normal component of acceleration of the collar B";
Real a(unit="m/s^2")"total acceleraion of the collar B";

Real a_BA(unit="m/s^2")"acceleration of B w.r.t arm OA";

Real v_t_30(unit="m/s")"total velocity of the collar B at theta=30 degree";
Real beta(unit="degree")"direction of v_t_30";
Real a_t_30(unit="m/s^2")"total acceleration of the collar B at theta=30 degree";
Real gama(unit="degree")"direction of a_t_30";
Real a_BA_30(unit="m/s^2")"acceleration of B w.r.t arm OA at theta=30 degree";

equation
theta_f_rad=Modelica.SIunits.Conversions.from_deg(theta_f_deg);

theta=0.15*time^2;
theta_dot=der(theta);
theta_ddot=der(theta_dot);

r=0.9-0.12*time^2;
r_dot=der(r);
r_ddot=der(r_dot);

v_r=r_dot;
v_theta=r*theta_dot;
v=sqrt(v_r^2+v_theta^2);

a_r=r_ddot-r*theta_dot^2;
a_theta=r*theta_ddot+2*r_dot*theta_dot;
a=sqrt(a_r^2+a_theta^2);

a_BA=r_ddot;

when theta>=theta_f_rad-0.0005 and theta<=theta_f_rad+0.0005 then
v_t_30=v;
beta=atan(v_theta/abs(v_r))*(180/pi);
a_t_30=a;
gama=atan(a_theta/a_r)*(180/pi);
a_BA_30=a_BA;
end when;
end Ex11_12;
