class Ex11_7
/*StopTime should be taken exactly 20 second to simulate the result*/
/*Number-a*/
parameter Real y_f(unit="m")=-150"final vertical position of the projectile w.r.t. origin";
parameter Real v_0(unit="m/s")=180"initial velocity of the projectile";
parameter Real a(unit="m/s^2")=-9.81"acceleration of the projectile in the vertical direction";
parameter Real theta_deg(unit="deg")=30"initial direction of the projectile w.r.t. horizontal direction in degree unit";
Real theta(unit="rad")"initial direction of the projectile w.r.t. horizontal direction in radian unit";
Real v_x0(unit="m/s")"initial x-component of the velocity of the projectile";
Real v_y0(unit="m/s")"initial y-component of the velocity of the projectile";

Real y(unit="m")"vertical position of the projectile";
Real x(unit="m")"horizontal position of the projectile";
Real v_y(unit="m/s")"y-component of the velocity of the projectile";

Real t(unit="s")"required time to reach ground";
Real x_ground(unit="m")"covered horizontal distance";

/*Number-b*/
Real y_v0(unit="m")"distance covered in vertical direction when velocity is zero"; 
Real y_max(unit="m")"maximum distance covered in the vertical direction from ground";
equation
/*Number-a*/
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
v_x0=v_0*cos(theta);
v_y0=v_0*sin(theta);

y=v_y0*time+(1/2)*a*time^2;
v_y^2=v_y0^2+2*a*y;
x=v_x0*time;
when y>=y_f-0.8 and y<=y_f+0.8 then
t=time;
x_ground=x;
end when;

/*Number-b*/
when v_y>=0-0.3 and v_y<=0+0.3 then
y_v0=y;
end when;
y_max=abs(y_f)+y_v0;
end Ex11_7;
