class Ex11_8
parameter Real x_B(unit="ft")=12000"horizontal position of target B w.r.t. projectile A";
parameter Real y_B(unit="ft")=2000"vertical position of target B w.r.t. projectile A";
parameter Real v_0(unit="ft/s")=800"initial velocity of the projectile";
parameter Real a(unit="ft/s^2")=-32.2"acceleration of the projectile in the vertical direction";

Real v_x0(unit="ft/s")"initial x-component of the velocity of the projectile";
Real v_y0(unit="ft/s")"initial y-component of the velocity of the projectile";

Real y(unit="ft")"vertical position of the projectile";
Real x(unit="ft")"horizontal position of the projectile";

Real t(unit="s",start=0.01)"required time for the projectile to reach target B";
Real theta(unit="rad",start=0.01)"initial direction of the projectile w.r.t. horizontal direction in radian unit";
Real theta_deg(unit="deg")"initial direction of the projectile w.r.t. horizontal direction in degree unit";
equation
v_x0=v_0*cos(theta);
v_y0=v_0*sin(theta);

x=v_x0*t;
y=v_y0*t+(1/2)*a*t^2;

x=x_B;
y=y_B;
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);
end Ex11_8;
