class Ex12_5
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";

parameter Real rho(unit="m")=2"length of the cord";
parameter Real theta_deg(unit="deg")=30"anglular position of the of the bob in degree unit";
Real theta(unit="rad")"angular position of the of the bob in radian unit";

Real a_t(unit="m/s^2")"tangential component of acceleration of the bob";
Real a_n(unit="m/s^2")"normal component of acceleration of the bob";
Real v_plus(unit="m/s")"positive velcocity of the bob";
Real v_negative(unit="m/s")"negative velcocity of the bob";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
g*sin(theta)=a_t;
2.5*g-g*cos(theta)=a_n;
v_plus=+sqrt(rho*a_n);
v_negative=-sqrt(rho*a_n);
end Ex12_5;
