class Ex13_12
/*Number-a*/
parameter Real m_p(unit="kg")=10"mass of the package";
parameter Real m_c(unit="kg")=25"mass of the cart";
parameter Real v_1(unit="m/s")=3"initial velocity of the package";
parameter Real theta_deg(unit="deg")=30"direction of the pakage in degree unit";
Real theta(unit="rad")"direction of the package in radian unit";
Real v_2(unit="m/s")"final velocity of the package and cart";

/*Number-b*/
Real Fdt(unit="lb")"exerted impulse";
Real Fdt_x(unit="lb")"x-component of the exerted impulse";
Real Fdt_y(unit="lb")"y-component of the exerted impulse";
Real alpha_deg(unit="deg")"direction of the exerted impulse in degree unit";
Real alpha(unit="rad")"direction of the exerted impulse in radian unit";

/*Number-c*/
Real T_1(unit="J")"initial kinetic energy of the system";
Real T_2(unit="J")"final kinetic energy of the system";
Real dE"lost energy";
equation
/*Number-a*/
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
m_p*v_1*cos(theta)=(m_p+m_c)*v_2;

/*Number-b*/
m_p*v_1*cos(theta)+Fdt_x=m_p*v_2;
-m_p*v_1*sin(theta)+Fdt_y=0;
Fdt=sqrt(Fdt_x^2+Fdt_y^2);
alpha=atan(Fdt_y/abs(Fdt_x));
alpha_deg=Modelica.SIunits.Conversions.to_deg(alpha);

/*Number-c*/
T_1=(1/2)*m_p*v_1^2;
T_2=(1/2)*(m_p+m_c)*v_2^2;
dE=(T_1-T_2)/T_1;
end Ex13_12;
