class Ex16_2
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=8"mass of the plate";
parameter Real DC(unit="m")=500/1000"length of the late";
parameter Real BC(unit="m")=200/1000"width of the late";
parameter Real AE(unit="m")=500/1000"length of the link AE";
parameter Real DF(unit="m")=500/1000"length of the link DF";
parameter Real theta_deg(unit="deg")=30"angle of link in degree unit";
Real theta(unit="rad")"angle of link in radian unit";

Real W(unit="N")"weight of the plate";
Real a_bar(unit="m/s^2")"acceleration of the plate";
Real F_AE(unit="N")"force in link AE";
Real F_DF(unit="N")"force in link DF";
equation
W=m*g;
W*cos(theta)=m*a_bar;
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
F_AE+F_DF-W*sin(theta)=0;
F_AE*sin(theta)*(DC/2)-F_AE*cos(theta)*(BC/2)+F_DF*sin(theta)*(DC/2)+F_DF*cos(theta)*(BC/2)=0;
end Ex16_2;
