class Ex16_7
/*Number-a*/
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W(unit="lb")=60"weight of the plate";
Real m(unit="lbm")"mass of the plate";
parameter Real a(unit="ft")=8/12"length of the late";
parameter Real b(unit="ft")=6/12"width of the late";
Real r_bar(unit="ft")"distance between center of mass and A";

Real a_bar(unit="ft/s^2")"total acceleration of the plate";
Real alpha(unit="rad/s^2")"angular acceleration of the plate";
Real I_bar(unit="lb.ft.s^2")"moment of inertia of the plate";

/*Number-b*/
Real A_x(unit="lb")"x-component of the reaction at pin A";
Real A_y(unit="lb")"y-component of the reaction at pin A";
equation
/*Number-a*/
m=W/g;
r_bar=sqrt((a/2)^2+(b/2)^2);
a_bar=r_bar*alpha;
W*(a/2)=m*a_bar*r_bar+I_bar*alpha;
I_bar=(m/12)*(a^2+b^2);

/*Number-b*/
A_x=-(3/5)*m*a_bar;
A_y-W=-(4/5)*m*a_bar;
end Ex16_7;
