class Ex17_2
parameter Real pi=Modelica.Constants.pi;
parameter Real m_A(unit="kg")=10"mass of the gear A";
parameter Real r_A(unit="m")=250/1000"radius of the gear A";
parameter Real k_A(unit="m")=200/1000"radius of gyration of the gear A";
Real I_A(unit="kg.m^2")"moment of inertia of the gear A";
Real w_A(unit="rad/s")"angular velocty of the gear A when w_B=600 rpm";

parameter Real m_B(unit="kg")=3"mass of the gear B";
parameter Real r_B(unit="m")=100/1000"radius of the gear B";
parameter Real k_B(unit="m")=80/1000"radius of gyration of the gear A";
parameter Real w_B(unit="rad/s")=600*((2*pi)/60)"given angular velocty of the gear B";
Real I_B(unit="kg.m^2")"moment of inertia of the gear B";

parameter Real T_1(unit="J")=0"initial kinetic energy of the system";
Real T_2(unit="J")"kinetic energy of the system when w_B=600 rpm";
parameter Real M(unit="N.m")=6"applied couple";
Real U_12(unit="J")"work done on the system";
Real theta_B(unit="rad")"angular displacement of the gear B when w_B=600 rpm";
Real N(unit="rev")"number of revolution by gera B when w_B=600 rpm ";


parameter Real T_1A(unit="J")=0"initial kinetic energy of the gear A";
Real T_2A(unit="J")"kinetic energy of the system when w_B=600 rpm";
Real F(unit="N")"tangential force on A";
Real U_12A(unit="J")"work done on the gear A";
equation
r_A*w_A=r_B*w_B;
I_A=m_A*k_A^2;
I_B=m_B*k_B^2;

T_2=(1/2)*I_A*w_A^2+(1/2)*I_B*w_B^2;
U_12=M*theta_B;
T_1+U_12=T_2;
N=theta_B/(2*pi);

T_2A=(1/2)*I_A*w_A^2;
U_12A=F*(theta_B*r_B);
T_1A+U_12A=T_2A;

end Ex17_2;
