class Ex17_6
parameter Real pi=Modelica.Constants.pi;
parameter Real m_A(unit="kg")=10"mass of the gear A";
parameter Real r_A(unit="m")=250/1000"radius of the gear A";
parameter Real k_A(unit="m")=200/1000"radius of gyration of the gear A";
Real I_A(unit="kg.m^2")"moment of inertia of the gear A";
Real w_A2(unit="rad/s")"angular velocty of the gear A when w_B=600 rpm";

parameter Real m_B(unit="kg")=3"mass of the gear B";
parameter Real r_B(unit="m")=100/1000"radius of the gear B";
parameter Real k_B(unit="m")=80/1000"radius of gyration of the gear A";
parameter Real w_B2(unit="rad/s")=600*((2*pi)/60)"given angular velocty of the gear B";
Real I_B(unit="kg.m^2")"moment of inertia of the gear B";
parameter Real M(unit="N.m")=6"applied couple";

Real t(unit="s",start=0.001)"required time";
Real F(unit="N")"tangential force on A";

equation
r_A*w_A2=r_B*w_B2;
I_A=m_A*k_A^2;
I_B=m_B*k_B^2;

0-F*t*r_A=-I_A*w_A2;
0+M*t-F*t*r_B=I_B*w_B2;

end Ex17_6;
