class Ex17_8
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W(unit="lb")=2"weight of the plate";
Real m_s(unit="lbm")"mass of the plate"; 
parameter Real a(unit="ft")=3/12"radius of the sphere";
parameter Real r_1(unit="ft")=5/12"initial position of the sphere";
parameter Real r_2(unit="ft")=25/12"final position of the sphere";
parameter Real w_1(unit="rad/s")=6"initial angular velocity of the system";
Real w_2(unit="rad/s")"final angular velocity of the system";
parameter Real I_R(unit="lb.ft.s^2")=0.25"centroidal moment of inertia of the rod and pivot";
Real I_s(unit="lb.ft.s^2")"moment of inertia of the sphere";

Real T_1(unit="ft.lb")"initial kinetic energy ofthe system";
Real T_2(unit="ft.lb")"final kinetic energy ofthe system";
Real dT(unit="ft.lb")"lost energy";
equation
m_s=W/g;
I_s=(2/5)*m_s*a^2;
(2*m_s*r_1^2+2*I_s+I_R)*w_1=(2*m_s*r_2^2+2*I_s+I_R)*w_2;


T_1=(1/2)*(2*m_s*r_1^2+2*I_s+I_R)*w_1^2;
T_2=(1/2)*(2*m_s*r_2^2+2*I_s+I_R)*w_2^2;
dT=T_2-T_1;
end Ex17_8;
