class Ex17_9
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real W_B(unit="lb")=0.05"weight of the bullet";
Real m_B(unit="lbm")"mass of the bullet";
parameter Real W_p(unit="lb")=20"weight of the plate";
Real m_p(unit="lbm")"mass of the plate";

parameter Real b(unit="ft")=18/12"length of the plate";
Real l_2(unit="ft")=b/2"CG of the plate";
Real l_1(unit="ft")=14/12"hitting point of the bullet";

parameter Real v_B(unit="ft/s")=1500"velocity of the bullet";
Real v_2(unit="ft/s")"velocity of the plate after hitting";
Real w_2(unit="rad/s")"angular velocity of the plate after hitting";

Real I_p(unit="kg.m^2")"moment of inertia of the plate";
Real A_x(unit="lb")"x-component of the reaction force at A";
Real A_y(unit="lb")"y-component of the reaction force at A";
parameter Real dt(unit="s")=0.0006"embeded time";
equation
m_B=W_B/g;
m_p=W_p/g;
m_B*v_B*l_1=m_p*v_2*l_2+I_p*w_2;
m_B*v_B+A_x*dt=m_p*v_2;
0+A_y*dt=0;
I_p=(1/6)*m_p*b^2;
v_2=l_2*w_2;
end Ex17_9;
