class Ex18_3
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="ft/s^2")=32.2"acceleration due to gravity";
parameter Real L(unit="ft")=8"length of the rod";
parameter Real W(unit="lb")=40"weight of the rod";
Real m(unit="lbm")"mass of the rod";
parameter Real beta_deg(unit="deg")=60"angle between AB and horizontal in degree unit";
Real beta(unit="rad")"angle between AB and horizontal in radian unit";
parameter Real w(unit="rad/s")=15"magnitude of the angular velocity of DE";
Real w_x(unit="rad/s")"x-component of the angular velocity of rod"; 
Real w_y(unit="rad/s")"y-component of the angular velocity of rod";
Real w_z(unit="rad/s")"z-component of the angular velocity of rod";
Real r_bar(unit="ft")"distance between G and DE";
Real a_bar[3](each unit="ft/s^2")"accaeleration of G";
Real I_x(unit="lbm.m^2")"mass moment of inertia about x-axis";
Real I_y(unit="lbm.m^2")"mass moment of inertia about y-axis";
Real I_z(unit="lbm.m^2")"mass moment of inertia about z-axis";
Real H_G[3](each unit="lb.ft")"angular momentum of G";
Real H_G_dot[3](each unit="lb.ft")"rate of change of angular momentum of G";
Real AC(unit="ft")"length of AC";
Real T_mag(unit="lb")"magnitude of the tension in wire";
Real T[3](each unit="lb")=T_mag*{-1,0,0}"tension in wire";
Real M_A_left[3](each unit="lb.ft")"left hand side of the moment equation";
Real M_A_right[3](each unit="lb.ft")"left hand side of the moment equation";
Real A[3](each unit="lb")"reaction at A";
equation
beta=Modelica.SIunits.Conversions.from_deg(beta_deg);
m=W/g;
r_bar=(1/2)*L*cos(beta);
a_bar={-r_bar*w^2,0,0};
I_x=(1/12)*m*L^2;
I_y=0;
I_z=(1/12)*m*L^2;
w_x=-w*cos(beta);
w_y=-w*sin(beta);
w_z=0;
H_G={I_x*w_x,I_y*w_y,I_z*w_z};
H_G_dot=cross({-w*cos(beta),w*sin(beta),0},H_G);
AC=L*cos(pi/2-beta);
M_A_left=cross(AC*{0,1,0},T)+cross({2,0,0},W*{0,-1,0});
M_A_right=cross((AC/2)*{0,1,0},m*a_bar)+H_G_dot;
M_A_left[3]=M_A_right[3];
A+T-W*{0,1,0}=m*a_bar;
/*The  answer may slightly vary due to  rounding off values*/
end Ex18_3;
