class Ex18_4
parameter Real pi=Modelica.Constants.pi;
parameter Real c(unit="m")=100/1000"length of the rod A and B";
parameter Real m(unit="kg")=300/1000"mass of the rod A and B";
parameter Real M_mag(unit="N.m")=6"magnitude of the applied couple";
parameter Real M[3](each unit="N.m")=M_mag*{1,0,0}"applied couple";
parameter Real w_mag(unit="rad/s")=1200*((2*pi)/60)"magnitude of the angular velocity of the shaft";
Real w[3](each unit="rad/s")=w_mag*{1,0,0}"angular velocity of the shaft";
Real H_O[3](each unit="N.m^2/s")"angular momentum about O";
Real alpha(unit="rad/s^2")"angular acceleration";
Real M_O_EF[3](each unit="N.m")"moment of the external forces about O";
Real M_O_DR[3](each unit="N.m")"moment due to reaction forces and couple about O";
Real I_x(unit="kg.m^2")"moment of inertia about x";
Real I_xy(unit="kg.m^2")"moment of inertia in xy plane";
Real I_xz(unit="kg.m^2")"moment of inertia in xz plane";
Real L(unit="m")"length of the shaft CD";
Real D_y(unit="N")"y-component of raction at D";
Real D_z(unit="N")"z-component of raction at D";
Real D[3](each unit="N")"raction at D";
Real C_y(unit="N")"y-component of raction at C";
Real C_z(unit="N")"z-component of raction at C";
Real C[3](each unit="N")"raction at C";
equation
H_O={I_x,-I_xy,-I_xz}*w_mag;
M_O_EF={I_x,-I_xy,-I_xz}*alpha+cross(w,H_O);
D={0,D_y,D_z};
L=(150+150+300)/1000;
M_O_DR=cross(L*{1,0,0},D)+M;
M_O_EF[1]=M_O_DR[1];
M_O_EF[2]=M_O_DR[2];
M_O_EF[3]=M_O_DR[3];
I_x=2*(1/3)*m*c^2;
I_xy=(1/4)*m*L*c;
I_xz=(1/8)*m*L*c;
C_y=-152.2;
C_z=-155.2;
C={0,C_y,C_z};
end Ex18_4;
