class Ex19_1
parameter Real pi=Modelica.Constants.pi;
parameter Real m(unit="kg")=50"mass of the block";
parameter Real x_m(unit="m")=40/1000"pulled length of the block";
parameter Real k_1(unit="N/m")=4*10^3"spring constnat of spring 1";
parameter Real k_2(unit="N/m")=6*10^3"spring constnat of spring 2";
parameter Real P(unit="N")=12*10^3"static load";

Real k_a(unit="N/m")"spring constnat for case a";
Real p_a(unit="rad/s")"angular velocity for case a";
Real tau_a(unit="s")"period of vibration for case a";
Real v_ma(unit="m/s")"maximum velocity for case a";
Real a_ma(unit="m/s^2")"maximum acceleration for case a";

Real delta_b(unit="m")"total elongation for case a";
Real k_b(unit="N/m")"spring constnat for case b";
Real p_b(unit="rad/s")"angular velocity for case b";
Real tau_b(unit="s")"period of vibration for case b";
Real v_mb(unit="m/s")"maximum velocity for case b";
Real a_mb(unit="m/s^2")"maximum acceleration for case b";

equation
k_a=k_1+k_2;
p_a^2=k_a/m;
tau_a=(2*pi)/p_a;
v_ma=x_m*p_a;
a_ma=x_m*p_a^2;

delta_b=P/k_1+P/k_2;
k_b=P/delta_b;
p_b^2=k_b/m;
tau_b=(2*pi)/p_b;
v_mb=x_m*p_b;
a_mb=x_m*p_b^2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex19_1;
