class Ex10_10
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m_A(unit="kg")=50"mass of A";
parameter Real m_B(unit="kg")=25"mass of B";
parameter Real k_g(unit="m")=0.25"radius of gyration of A";
parameter Real k(unit="N/m")=300"spring constant";
parameter Real P_i(unit="N")=200"initial tension in the spring";
parameter Real v_Oi(unit="m/s")=1.5"initial velocity of the O";
parameter Real D(unit="m")=0.8"diameter of A";
parameter Real r(unit="m")=D/2"radius of A";
parameter Real OG(unit="m")=0.2"distance between G and O";
parameter Real theta=90*(pi/180)"final angular position of A";

Real q_O[2](each unit="m")"displacement of point O";
Real q_E[2](each unit="m")"displacement of point E";
Real q_B[2](each unit="m")"displacement of point B";
Real U_50g(unit="J")"work done by the weight of A";
Real U_25g(unit="J")"work done by the weight of B";
Real P_f(unit="N")"finaltension in the spring";
Real U_P(unit="J")"work done by the spring";
Real U(unit="J")"total work done";

Real w_Ai(unit="rad/s")"initial angular velocity of A";
Real v_Gi(unit="m/s")"initial velocity of the G";
Real v_Bi(unit="m/s")"initial velocity of the B";

Real w_Af(unit="rad/s",start=0.001)"final angular velocity of A";
Real v_Gf(unit="m/s")"final velocity of the G";
Real v_Bf(unit="m/s")"final velocity of the B";
Real v_Of(unit="m/s")"mangitude of final velocity of the O";
Real v_Of_v[2](each unit="m/s")"final velocity of the O";
Real I_zA(unit="kg.m^2")"moment of inertia";
equation
q_O={-r*theta,0};
q_E=q_O+{-r*theta,0};
q_B=-q_E;
U_50g=m_A*g*OG;
U_25g=-m_B*g*q_B[1];
k=(P_i-P_f)/abs(q_O[1]);
U_P=((P_i+P_f)/2)*abs(q_O[1]);
U=U_50g+U_25g+U_P;
w_Ai=v_Oi/r;
v_Gi=sqrt((r^2+OG^2))*w_Ai;
v_Bi=D*w_Ai;

v_Gf=OG*w_Af;
v_Bf=D*w_Af;
v_Of=r*w_Af;
I_zA=m_A*k_g^2-m_A*OG^2;
U=(1/2)*m_A*(v_Gf^2-v_Gi^2)+(1/2)*I_zA*(w_Af^2-w_Ai^2)+(1/2)*m_B*(v_Bf^2-v_Bi^2);

v_Of_v={-v_Of,0};
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_10;
