class Ex10_5
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m(unit="kg")=1"mass of the collar";
parameter Real k(unit="N/m")=60"spring constant";
parameter Real r(unit="m")=1.2"radius of the wire";
parameter Real l_0(unit="m")=0.9"unstressed length of the spring";
Real l_1(unit="m")"length of the spring at position A";
Real l_2(unit="m")"length of the spring at position A_das";
Real s_i(unit="m")"stressed length of the spring at position A";
Real s_f(unit="m")"stressed length of the spring at position A_das";

Real V_i(unit="J")"potential energy of the system at position A";
Real V_f(unit="J")"potential energy of the system at position A_das";
Real T_i(unit="J")"kinetic energy of the system at position A";
Real T_f(unit="J")"kinetic energy of the system at position A_das";

parameter Real v_i(unit="m/s")=1"velocity of the collar at position A";
Real v_f(unit="m/s")"velocity of the collar at position A_das";
equation
l_1=l_0+r;
l_2=sqrt(l_0^2+r^2);
s_i=r;
s_f=l_2-l_0;
V_i=(1/2)*k*s_i^2+m*g*r;
T_i=(1/2)*m*v_i^2;
V_f=(1/2)*k*s_f^2+m*g*0;
T_f=(1/2)*m*v_f^2;
T_i+V_i=T_f+V_f;
end Ex10_5;
