class Ex11_11
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81"acceleration due to gravity";
parameter Real m_0(unit="kg")=3600"initial mass of the rocket";
parameter Real m_p(unit="kg")=3000"mass of the fuel";
parameter Real t(unit="s")=80"fuel comsumed time";
parameter Real v_em(unit="m/s")=1500"speed of the exhust gases relative to the rocket";
Real b(unit="kg/s")"burnout rate";
Real a(unit="m/s^2")"acceleration of the rocket";
Real v(unit="m/s")"velocity of the rocket";
Real y(unit="m")"achieved altitude of the rocket";
equation
b=m_p/t;
a=(b*v_em)/(m_0-b*t)-g;
v=-v_em*log((m_0-b*t)/m_0)-g*t;
y=((m_0*v_em)/b)*(((m_0-b*t)/m_0)*(log((m_0-b*t)/m_0)-1)+1)-(1/2)*g*t^2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex11_11;
