class Ex11_18
parameter Real pi=Modelica.Constants.pi;
parameter Real m_AB(unit="kg")=10"mass of the bar AB";
parameter Real AG(unit="m")=600/1000"length of AG";
parameter Real b(unit="m")=300/1000"length of DG";
parameter Real BD(unit="m")=300/1000"length of BD";
parameter Real w_i(unit="rad/s")=5"angular velocity of AB before impact";
Real w_f(unit="rad/s")"angular velocity of AB just after impact";
parameter Real m_C(unit="kg")=2"mass of C";
parameter Real v(unit="m/s")=15"velocity of C";
Real v_Cxi(unit="m/s")"initial x-component of the velocity of C";
Real v_Cyi(unit="m/s")"initial y-component of the velocity of C";
Real v_Cxf(unit="m/s")"final x-component of the velocity of C";
Real v_Cyf(unit="m/s")"final y-component of the velocity of C";
Real v_Cf[2](each unit="m/s")"final velocity of C";
Real theta(unit="rad/s")"direction of v_CF";

Real v_Gxi(unit="m/s")"initial x-component of the velocity of G";
Real v_Gxf(unit="m/s")"final x-component of the velocity of G";
Real I_G(unit="kg.m^2")"moment of inertia of AB";
parameter Real e=0.9"coefficient of restitution";
Real v_Dxi(unit="m/s")"initial x-component of the velocity of D";
Real v_Dxf(unit="m/s")"final x-component of the velocity of D";

equation
v_Cxi=v*cos(atan(3/4));
v_Cyi=v*sin(atan(3/4));
v_Cyf=v_Cyi;
v_Gxi=0;
I_G=(m_AB*(AG+b+BD)^2)/12;
m_AB*v_Gxi+m_C*v_Cxi=m_AB*v_Gxf+m_C*v_Cxf;
m_C*v_Cxi*b+I_G*w_i=m_C*v_Cxf*b+I_G*w_f;
e=-(v_Cxf-v_Dxf)/(v_Cxi-v_Dxi);
v_Dxi=v_Gxi+b*w_i;
v_Dxf=v_Gxf+b*w_f;
v_Cf={v_Cxf,v_Cyf};
theta=atan(v_Cyf/abs(v_Cxf))*(180/pi);


end Ex11_18;
